#include <Servo.h> // 서보모터 라이브러리 불러오기 

Servo myServo; // 서보모터 객체 선언

int cdsPin = A1;  // 조도센서를 아날로그 A1핀에 연결
int servoMotorPin = 9; // 서보모터를 9번 핀에 연결

int cdsValue = 0;
int angle = 0;

void setup() {
  myServo.attach(servoMotorPin);
  Serial.begin(9600);
}

void loop() {
  cdsValue = analogRead(cdsPin); // 조도센서의 값을 읽음
  Serial.print("cds value: "); // 시리얼 모니터에 조도 센서의 값을 출력
  Serial.println(cdsValue);
  
  angle = map(cdsValue, 0, 1023, 0, 179); // 조도센서의 값을 각도로 변환
  Serial.print("angle: ");  // 시리얼 모니터에 각도를 출력
  Serial.println(angle);
  
  myServo.write(angle); // 서보모터에 각도를 출력
  delay(100);
}